/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.util;

import java.io.ByteArrayInputStream;

public class Version {
    public static final boolean checkLicense(String stamp) {
        try {
            boolean bl = Version.checkLicense(stamp, true);
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final boolean checkLicense(String stamp, boolean exit) throws Exception {
        block9: {
            byte[] buf = Version.extractTagFromStamp(stamp, (short)53);
            if (buf != null && ((buf = Version.extractTagFromStamp(stamp, (short)54)) == null || (buf = Version.extractTagFromStamp(stamp, (short)55)) == null || new String(buf).equals(""))) {
                buf = Version.extractTagFromStamp(stamp, (short)51);
                if (buf != null) {
                    if (new String(buf).equals("Eval")) {
                        try {
                            buf = Version.extractTagFromStamp(stamp, (short)2);
                            long expiryTime = Long.valueOf(new String(buf));
                            long currentTime = System.currentTimeMillis();
                            if ((expiryTime * (long)1000 - currentTime) / 86400000L < (long)0) {
                                throw new Exception();
                            }
                            break block9;
                        }
                        catch (Exception e) {
                            if (!exit) {
                                throw e;
                            }
                            System.err.println("License has expired.");
                            System.exit(1);
                            boolean bl = false;
                            return bl;
                        }
                    }
                    if (exit) {
                        System.err.println("This product might not have been installed");
                        System.err.println(" correctly. Please use the product installer");
                        System.err.println(" to install the product.");
                        System.exit(1);
                    }
                    return false;
                }
                if (exit) {
                    System.err.println("This product might not have been installed");
                    System.err.println(" correctly. Please use the product installer");
                    System.err.println(" to install the product.");
                    System.exit(1);
                }
                return false;
            }
        }
        return true;
    }

    private static byte[] extractTagFromStamp(String stamp, short tagId) {
        if (!stamp.startsWith("@@@@")) {
            return null;
        }
        if (!stamp.endsWith("@@@@")) {
            return null;
        }
        byte[] buffer = stamp.getBytes();
        ByteArrayInputStream input = new ByteArrayInputStream(buffer);
        int tagLength = 0;
        boolean tagEncoded = false;
        input.skip(11L);
        int stampStringNumTags = input.read() - 1;
        input.skip(20L);
        for (int i = 1; i <= stampStringNumTags; ++i) {
            int tagIdFromStamp = input.read();
            int tagFormat = input.read();
            tagLength = input.read();
            tagEncoded = false;
            if (((long)tagFormat & 0x40L) == 64L) {
                tagEncoded = true;
                --tagLength;
                input.skip(1L);
            }
            byte[] tagExtracted = new byte[tagLength];
            for (int k = 1; k <= tagLength; ++k) {
                tagExtracted[k - 1] = (byte)input.read();
            }
            byte[] decodedTag = null;
            if (tagEncoded) {
                int len = tagExtracted.length;
                byte[] decoded = new byte[len];
                decoded[len - 1] = (byte)((long)tagExtracted[len - 1] - -7L);
                decoded[0] = (byte)((long)tagExtracted[0] - -7L - (long)decoded[len - 1] % -13L);
                for (int j = len - 2; j > 0; --j) {
                    decoded[j] = (byte)((long)tagExtracted[j] - (long)decoded[j + 1] % -13L - -7L);
                }
                decodedTag = decoded;
            }
            if (tagIdFromStamp != tagId) continue;
            if (tagEncoded) {
                return decodedTag;
            }
            return tagExtracted;
        }
        return null;
    }

    public static final String getVersion(String stamp) {
        StringBuffer buffer = new StringBuffer();
        byte[] val = Version.extractTagFromStamp(stamp, (short)4);
        if (val != null) {
            buffer.append(new String(val));
        }
        if ((val = Version.extractTagFromStamp(stamp, (short)3)) != null) {
            buffer.append(" [");
            buffer.append(new String(val));
            buffer.append("]");
        }
        if ((val = Version.extractTagFromStamp(stamp, (short)7)) != null) {
            buffer.append(" (");
            buffer.append(new String(val));
            buffer.append(")");
        }
        return buffer.toString();
    }

    public static final String java() {
        return String.valueOf(new StringBuffer("Java: Version ").append(Version.sysprop("java.version")).append(" from ").append(Version.sysprop("java.vendor")));
    }

    public static final String platform() {
        return String.valueOf(new StringBuffer("OS:   ").append(Version.sysprop("os.name")).append(" version ").append(Version.sysprop("os.version")).append("; CPU: ").append(Version.sysprop("os.arch")));
    }

    public static String sysprop(String name) {
        try {
            String string = System.getProperty(name);
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
    }
}

